package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.datalayer.RequestEligibilityCriteriaRepository;
import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.linkbuilder.LinkBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.core.UriInfo;
import java.util.List;

@Service
public class RequestEligibilityCriteriaService {

    @Autowired
    private RequestEligibilityCriteriaRepository requestEligibilityCriteriaRepository;

    @Autowired
    private CoreSettingsService coreSettingsService;

    @Autowired
    private CustomRequestSettingsService customRequestSettingsService;

    public RequestEligibilityCriteria fetchRequestEligibiltyCriteria(String siteCode, List<ClinicalServices> requestServices, List<ClinicalServices> customRequestServices, UriInfo uriInfo) {

        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById(siteCode);
        if (requestEligibilityCriteria == null) {
            requestEligibilityCriteria = new RequestEligibilityCriteria();
            requestEligibilityCriteria.setId(siteCode);
            requestEligibilityCriteria.setRequestSettings(coreSettingsService.createDefaultCoreSettings(requestServices));
            requestEligibilityCriteria.setCustomRequestSettings(customRequestSettingsService.createDefaultCustomRequestSettings(customRequestServices));
        } else {
            CustomRequestSettings customRequestSettings = requestEligibilityCriteria.getCustomRequestSettings();
            if (customRequestSettings == null || customRequestSettings.size() == 0) {
                customRequestSettings = customRequestSettingsService.createDefaultCustomRequestSettings(customRequestServices);
            }
            requestEligibilityCriteria.setCustomRequestSettings(customRequestSettingsService.updateCriteriaCoreSettings(customRequestSettings, customRequestServices));
            CoreSettings coreSettings = requestEligibilityCriteria.getRequestSettings();
            requestEligibilityCriteria.setRequestSettings(coreSettingsService.updateCriteriaCoreSettings(coreSettings, requestServices));
            LinkBuilder.fillLink(requestEligibilityCriteria, uriInfo.getRequestUri());
        }
        return requestEligibilityCriteria;
    }

    public RequestEligibilityCriteria saveRequestEligibilityCriteria (RequestEligibilityCriteria requestEligibilityCriteria) {
        return requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
    }

    public RequestEligibilityCriteria updateRequestEligibilityCriteria (RequestEligibilityCriteria requestEligibilityCriteria) {
        return requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
    }
}
